#include<iostream>
#include<vector>
#include<algorithm>
#include<set>
using namespace std;

const int MAXN = 500005;
vector<vector<int>> graph(MAXN);
vector<long long> values(MAXN);
set<int> nodes_on_paths;
int N, M, Q, P;

void dfs(int curr, int end, vector<bool>& used, vector<int>& path) {
    used[curr] = true;
    path.push_back(curr);
    
    if (curr == end) {
        for (int node : path) {
            nodes_on_paths.insert(node);
        }
    } else {
        for (int next : graph[curr]) {
            if (!used[next]) {
                dfs(next, end, used, path);
            }
        }
    }
    
    used[curr] = false;
    path.pop_back();
}

long long get_median(int start, int end) {
    nodes_on_paths.clear();
    vector<bool> used(N + 1, false);
    vector<int> path;
    
    
    dfs(start, end, used, path);
    
    
    vector<long long> path_values;
    for (int node : nodes_on_paths) {
        path_values.push_back(values[node]);
    }
    sort(path_values.begin(), path_values.end());
    
    
    int size = path_values.size();
    return path_values[(size - 1) / 2];
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    
    
    cin >> N >> M >> Q >> P;
    
    for(int i=1; i<=N;i++){
        cin >> values[i];
    }
    
    for(int i=0;i<M;i++){
        int u, v;
        cin >> u >> v;
        graph[u].push_back(v);
        graph[v].push_back(u);
    }
    
    
    long long prev_ans = 0;
    for(int i=0;i<Q;i++){
        int a1, b1;
        cin >> a1 >> b1;
        
        
        int a = (a1 + prev_ans * P - 1) % N + 1;
        int b = (b1 + prev_ans * P - 1) % N + 1;
        
       
        prev_ans = get_median(a, b);
        cout << prev_ans << "\n";
    }
    
    return 0;
}